local dragonchaos={ dragonlife=4.5,spawninterval=0.18,fadealpha=0.9995,smearspeed=0.51,smearscale=0.900 }
function dragonchaos.load(screenWidth,screenHeight)
math.randomseed(os.time())
dragonchaos.dragon_images={}
local filenames={ "dragonicon1.png","dragonicon2.png","dragonicon3.png","dragonicon4.png","dragonicon5.png","dragonicon6.png","dragonicon7.png","dragonicon8.png","dragonicon9.png" }
for _,fname in ipairs(filenames) do
local img=love.graphics.newImage(fname)
img:setFilter("nearest","nearest")
table.insert(dragonchaos.dragon_images,img)
end
dragonchaos.canvas1=love.graphics.newCanvas(screenWidth,screenHeight)
dragonchaos.canvas2=love.graphics.newCanvas(screenWidth,screenHeight)
dragonchaos.current=dragonchaos.canvas1
dragonchaos.backup=dragonchaos.canvas2
dragonchaos.time=0
dragonchaos.spawntimer=0
dragonchaos.dragons={}
end
function dragonchaos.spawndragon()
local w=dragonchaos.current:getWidth()
local h=dragonchaos.current:getHeight()
local img=dragonchaos.dragon_images[math.random(#dragonchaos.dragon_images)]
table.insert(dragonchaos.dragons,{img=img,x=math.random(0,w),y=math.random(0,h),rot=math.random()*2*math.pi,scale=0.5+math.random()*0.3,color={0.3+math.random()*0.7,0.3+math.random()*0.7,0.3+math.random()*0.7},age=0,life=dragonchaos.dragonlife})
end
function dragonchaos.update(dt)
dragonchaos.time=dragonchaos.time+dt*0.1
dragonchaos.spawntimer=dragonchaos.spawntimer+dt
if dragonchaos.spawntimer>=dragonchaos.spawninterval then
dragonchaos.spawntimer=dragonchaos.spawntimer-dragonchaos.spawninterval
dragonchaos.spawndragon()
end
for i=#dragonchaos.dragons,1,-1 do
local g=dragonchaos.dragons[i]
g.age=g.age+dt
if g.age>=g.life then
table.remove(dragonchaos.dragons,i)
end end end
function dragonchaos.draw()
local prevCanvas=love.graphics.getCanvas()
local w=dragonchaos.current:getWidth()
local h=dragonchaos.current:getHeight()
local src,dst=dragonchaos.current,dragonchaos.backup
love.graphics.setCanvas(dst)
love.graphics.clear()
love.graphics.setColor(1,1,1,dragonchaos.fadealpha)
love.graphics.draw(src,w/2,h/2,dragonchaos.time*dragonchaos.smearspeed,dragonchaos.smearscale,dragonchaos.smearscale,w/2,h/2)
for _,g in ipairs(dragonchaos.dragons) do
local t=1-(g.age/g.life)
love.graphics.setColor(g.color[1],g.color[2],g.color[3],t)
love.graphics.draw(g.img,g.x,g.y,g.rot,g.scale,g.scale,g.img:getWidth()/2,g.img:getHeight()/2)
end
love.graphics.setCanvas(prevCanvas)
love.graphics.setColor(1,1,1,1)
love.graphics.draw(dst,0,0)
dragonchaos.current,dragonchaos.backup=dst,src
end
return dragonchaos
